CREATE TRIGGER E_DDL_BASE_CREATE_TABLE_REF
ON DATABASE
FOR CREATE_TABLE
AS

BEGIN --> TRIGGER CODE

-- Rcupration du nom de la table
DECLARE @TABLE_NAME sysname, @TABLE_SCHEMA sysname, @SQL NVARCHAR(max), @TRG NCHAR(3);
SELECT @TABLE_NAME = EVENTDATA().value('(/EVENT_INSTANCE/ObjectName)[1]', 'sysname'),
       @TABLE_SCHEMA = EVENTDATA().value('(/EVENT_INSTANCE/SchemaName)[1]', 'sysname');
SET @TRG = RIGHT(@TABLE_NAME, 3);

-- Si le schma nest pas S_REF, sortir
IF @TABLE_SCHEMA <> 'S_REF'
   RETURN;

BEGIN TRY --> EXCEPTION TEST

-- Aucune autre colonne que la colonne cl de forme xxx_ID
IF EXISTS (SELECT *
           FROM   INFORMATION_SCHEMA.COLUMNS
           WHERE  TABLE_NAME = @TABLE_NAME
             AND  TABLE_SCHEMA = 'S_REF'
             AND  COLUMN_NAME <> @TRG + '_ID')
   THROW 66666, 'La table ne doit comporter qu''une seule colonne', 16;

-- Vrification PK IDENTITY
IF NOT EXISTS(SELECT 1
              FROM   INFORMATION_SCHEMA.COLUMNS
              WHERE  COLUMN_NAME = @TRG + '_ID'
                AND  DATA_TYPE = 'int'
                AND  TABLE_SCHEMA = 'S_REF'
                AND  TABLE_NAME = @TABLE_NAME
                AND  OBJECTPROPERTYEX(OBJECT_ID('S_REF.' + @TABLE_NAME), 'TableHasIdentity') = 1
                AND OBJECTPROPERTYEX(OBJECT_ID('S_REF.' + @TABLE_NAME), 'TableHasPrimaryKey') = 1)
   THROW 66666, 'La table doit avoir une seule colonne PK INT IDENTITY', 16;

-- Ajout des colonnes manquantes
SET @SQL = 'ALTER TABLE ['+ @TABLE_SCHEMA + '].[' + @TABLE_NAME + '] '
         + 'ADD ' + @TRG + '_CODE CHAR(16) NOT NULL UNIQUE, '
         + @TRG + '_LIBELLE VARCHAR(250), '
         + @TRG + '_DH_OBSOLETE DATETIME2(0), '
         + @TRG + '_BASE BIT NOT NULL DEFAULT 0, '
         + @TRG + '_ORDRE INT;'
EXEC (@SQL);

END TRY --> EXCEPTION TEST
BEGIN CATCH --> EXCEPTION CATCH

IF XACT_STATE() <> 0
   ROLLBACK;
THROW;

END CATCH --> EXCEPTION CATCH
END --> TRIGGER CODE
GO